<?php

function getLatLngFromAddress($address){

    $address = urlencode($address);
    $apiKey = GOOGLE_MAPS_API_KEY;

    $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";
    $json = @file_get_contents($url);
    $data = json_decode($json);

    if($data->status === "OK"){
        return [
            'lat' => $data->results[0]->geometry->location->lat,
            'lng' => $data->results[0]->geometry->location->lng
        ];
    }

    return false;
}
?>
