<?php
require_once "../includes/config.php";
require_once "../includes/response.php";
require_once "../includes/block-system.php";

$data = json_decode(file_get_contents("php://input"),true);
$order_id = $data['order_id'];

$stmt = $pdo->prepare("SELECT restaurant_id,customer_phone FROM orders WHERE id=?");
$stmt->execute([$order_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$order){
    response(['error'=>'Not found'],404);
}

$pdo->prepare("UPDATE orders SET status='cancelled' WHERE id=?")->execute([$order_id]);

$blocked = checkAutoBlock($pdo,$order['restaurant_id'],$order['customer_phone']);

response([
  'success'=>true,
  'blocked'=>$blocked
]);
