<?php
function checkAutoBlock($pdo, $restaurant_id, $phone){

    // عدد مرات الإلغاء من جدول المطعم
    $limit = $pdo
        ->prepare("SELECT max_cancel_before_block FROM restaurants WHERE id=?");
    $limit->execute([$restaurant_id]);
    $max = $limit->fetchColumn() ?? 3;

    $stmt = $pdo->prepare("
        SELECT COUNT(*) FROM orders 
        WHERE restaurant_id=? 
        AND customer_phone=? 
        AND status='cancelled'
    ");
    $stmt->execute([$restaurant_id,$phone]);
    $count = $stmt->fetchColumn();

    if($count >= $max){

        $pdo->prepare("
            INSERT INTO blocked_customers 
            (restaurant_id,customer_phone,total_cancelled,is_blocked,block_reason)
            VALUES (?,?,?,1,'Auto block by system')
            ON DUPLICATE KEY UPDATE 
            is_blocked=1,
            total_cancelled=?
        ")->execute([$restaurant_id,$phone,$count,$count]);

        return true;
    }

    return false;
}
