<?php
require_once "config.php";

function base64UrlEncode($data){
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function generateJWT($payload){
    $header = base64UrlEncode(json_encode(['typ'=>'JWT','alg'=>'HS256']));
    $payload = base64UrlEncode(json_encode($payload));
    $signature = base64UrlEncode(hash_hmac('sha256', "$header.$payload", JWT_SECRET, true));
    return "$header.$payload.$signature";
}

function verifyJWT($token){
    $parts = explode('.', $token);
    if(count($parts) !== 3) return false;

    [$header,$payload,$signature] = $parts;
    $valid_signature = base64UrlEncode(hash_hmac('sha256',"$header.$payload",JWT_SECRET,true));

    if($signature !== $valid_signature) return false;

    return json_decode(base64_decode($payload));
}

function requireAuth(){
    $headers = apache_request_headers();
    if(!isset($headers['Authorization'])) {
        response(['error'=>'Token required'],401);
    }
    $token = str_replace('Bearer ','',$headers['Authorization']);
    $verify = verifyJWT($token);
    if(!$verify){
        response(['error'=>'Invalid token'],403);
    }
    return $verify;
}

