<?php

function assignDriver($pdo, $restaurant_id){

    $stmt = $pdo->prepare("
        SELECT id,user_id FROM drivers
        WHERE restaurant_id=?
        AND status IN ('available','returned')
        ORDER BY last_update ASC
        LIMIT 1
    ");
    $stmt->execute([$restaurant_id]);

    $driver = $stmt->fetch(PDO::FETCH_ASSOC);

    if($driver){
        return $driver['id'];
    }

    return null;
}
