<?php
require_once "../includes/auth.php";
require_once "../includes/response.php";

$headers = apache_request_headers();

if(!isset($headers['Authorization'])){
    response(['error'=>'Token required'],401);
}

$oldToken = str_replace('Bearer ','',$headers['Authorization']);
$data = verifyJWT($oldToken);

if(!$data){
    response(['error'=>'Invalid token'],403);
}

$newToken = generateJWT([
    'id'   => $data->id,
    'role' => $data->role,
    'time' => time()
]);

response(['token'=>$newToken]);

